/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hsc.ccfw.pa.ar;

import com.ibm.hwmca.fw.pa.problem.Problem;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.RootProcess;
import com.ibm.hwmca.fw.util.Trace;
import com.ibm.hwmca.xfw.pa.system.RemotePartitionSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystem;
import com.ibm.hwmca.xfw.pa.system.RemoteSystemManager;
import java.io.IOException;
import java.util.Iterator;
import java.util.Set;

public class LedAPI
implements Runnable {
    private int functionToPerform = 0;
    private String partionID = null;
    private static final String baseCMD = "chled";
    private static final String TRACE_MASKT = "XRUNACTT";
    private static final String TRACE_MASKF = "XRUNACTF";
    private static final String TRACE_MASKD = "XRUNACTD";
    private RemotePartitionSystem _parms = null;

    public LedAPI(RemotePartitionSystem remotePartitionSystem) {
        Trace.trace((String)TRACE_MASKT, (Object)("--> ledAPI.ctor (" + remotePartitionSystem + ")"));
        this._parms = remotePartitionSystem;
    }

    public void run() {
        Trace.trace((String)TRACE_MASKD, (Object)("running ledAPI with parm=" + this._parms));
        String string = this.getMOSForPartition(this._parms);
        if (string == null) {
            Trace.trace((String)TRACE_MASKT, (Object)"<--LedAPI returns, could not get MOS");
            return;
        }
        String string2 = " -r sa -t virtuallpar -m " + string + " -o on -p " + this._parms.getPartitionName() + " --id " + this._parms.getPartitionSlotId();
        String[] stringArray = new String[]{baseCMD, string2};
        Trace.trace((String)TRACE_MASKD, (Object)("calling NativeProcess to ledAPI with parms " + string2));
        int n = -1;
        try {
            n = RootProcess.executeProgram((String[])stringArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        Trace.trace((String)TRACE_MASKD, (Object)("NativeProcess of LedAPI completed with rc= " + n));
    }

    public static void main(String[] stringArray) {
    }

    public int getFunctionToPerform() {
        return this.functionToPerform;
    }

    public String getPartionID() {
        return this.partionID;
    }

    public void setFunctionToPerform(int n) {
        this.functionToPerform = n;
    }

    public void setPartionID(String string) {
        this.partionID = string;
    }

    private static int getExitStatus(NativeProcess nativeProcess) {
        boolean bl = false;
        int n = -1;
        while (!bl) {
            try {
                n = nativeProcess.waitFor();
                bl = true;
            }
            catch (InterruptedException interruptedException) {}
        }
        Trace.trace((String)TRACE_MASKF, (Object)("Exit status from root program = " + n));
        return n;
    }

    public Problem getProblem() {
        return null;
    }

    protected String getMOSForPartition(RemotePartitionSystem remotePartitionSystem) {
        RemoteSystemManager remoteSystemManager = RemoteSystemManager.getRemoteSystemManager();
        Set set = remoteSystemManager.getLiveSystems();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            RemoteSystem remoteSystem = (RemoteSystem)iterator.next();
            if (!remoteSystem.getMTMS().equals(remotePartitionSystem.getMTMS())) continue;
            return remoteSystem.getMOSystemName();
        }
        return null;
    }
}

